<?php
$pagina = 13;
define('PERMITIDO', true);
//initilize the page
require_once("../inc/init.php");

//require UI configuration (nav, ribbon, etc.)
require_once("../inc/config.ui.php");

/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */
$page_title = "Consulta Egresos";
/* ---------------- END PHP Custom Scripts ------------- */
//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";
include("../inc/header.php");

//include left panel (navigation)
//follow the tree in inc/config.ui.php
$page_nav['Caja']['sub']['registro_egresos']["active"] = true;
include("../inc/nav.php");

$currentPage = $_SERVER["PHP_SELF"];

$maxRows_reg_egresos = 50;
$pageNum_reg_egresos = 0;
if (isset($_GET['pageNum_reg_egresos'])) {
  $pageNum_reg_egresos = $_GET['pageNum_reg_egresos'];
}
$startRow_reg_egresos = $pageNum_reg_egresos * $maxRows_reg_egresos;

mysql_select_db($database_conexionlab, $conexionlab);
$query_reg_egresos = "SELECT egresos.ID_EG, egresos.TIPO_EGRESO, egresos.N_BOLETA, egresos.MONTO, egresos.ID_PROVEEDOR, egresos.ID_CENTRO_COSTO, egresos.FLAG_CIERRECAJA, usuarios.USUARIO, DATE_FORMAT(FECHA,'%d/%m/%Y') AS date2, LEFT (egresos.OBSERVACION,30) As OBS, empresas.NOMBRE_E FROM egresos  INNER JOIN usuarios ON egresos.ID_CAJERO=usuarios.ID_USUARIO LEFT JOIN empresas ON egresos.ID_PROVEEDOR=empresas.ID_EMPRESA ORDER BY ID_EG DESC";
$query_limit_reg_egresos = sprintf("%s LIMIT %d, %d", $query_reg_egresos, $startRow_reg_egresos, $maxRows_reg_egresos);
$reg_egresos = mysql_query($query_limit_reg_egresos, $conexionlab) or die(mysql_error());
$row_reg_egresos = mysql_fetch_assoc($reg_egresos);

if (isset($_GET['totalRows_reg_egresos'])) {
  $totalRows_reg_egresos = $_GET['totalRows_reg_egresos'];
} else {
  $all_reg_egresos = mysql_query($query_reg_egresos);
  $totalRows_reg_egresos = mysql_num_rows($all_reg_egresos);
}
$totalPages_reg_egresos = ceil($totalRows_reg_egresos/$maxRows_reg_egresos)-1;

$colname_user = "-1";
if (isset($_SESSION['MM_Username'])) {
  $colname_user = $_SESSION['MM_Username'];
}
mysql_select_db($database_conexionlab, $conexionlab);
$query_user = sprintf("SELECT ID_USUARIO, USUARIO FROM usuarios WHERE USUARIO = %s", GetSQLValueString($colname_user, "text"));
$user = mysql_query($query_user, $conexionlab) or die(mysql_error());
$row_user = mysql_fetch_assoc($user);
$totalRows_user = mysql_num_rows($user);

$queryString_reg_egresos = "";
if (!empty($_SERVER['QUERY_STRING'])) {
  $params = explode("&", $_SERVER['QUERY_STRING']);
  $newParams = array();
  foreach ($params as $param) {
    if (stristr($param, "pageNum_reg_egresos") == false && 
        stristr($param, "totalRows_reg_egresos") == false) {
      array_push($newParams, $param);
    }
  }
  if (count($newParams) != 0) {
    $queryString_reg_egresos = "&" . htmlentities(implode("&", $newParams));
  }
}
$queryString_reg_egresos = sprintf("&totalRows_reg_egresos=%d%s", $totalRows_reg_egresos, $queryString_reg_egresos);

ob_start();
?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->

	<!-- MAIN CONTENT -->
    
<?php if ($totalRows_reg_egresos > 0) { // Show if recordset not empty ?>
  <table class="table table-hover table-responsive table-bordered" id="dataTables-example">
  <thead>
    <tr bgcolor="#999999">
      <th>Fecha</th>
      <th>Usuario</th>
      <th>Tipo de Egreso</th>
      <th>Boleta</th>
      <th>Monto</th>
      <th>Proveedor</th>
      <th>Cierre de Caja</th>
      <th>OBS</td>
    </tr>
    </thead>
    <tbody>
    <?php do { ?>
      <tr>
        <td><?php echo $row_reg_egresos['date2']; ?></td>
        <td><?php echo $row_reg_egresos['USUARIO']; ?></td>
        <td><?php echo $row_reg_egresos['TIPO_EGRESO']; ?></td>
        <td><?php echo $row_reg_egresos['N_BOLETA']; ?></td>
        <td align="right" nowrap>$ <?php echo number_format($row_reg_egresos['MONTO'],0,',','.'); ?></td>
        <td><?php echo $row_reg_egresos['NOMBRE_E']; ?></td>
        <td><?php 
		if($row_reg_egresos['FLAG_CIERRECAJA']=='S'){
		echo "Si";
		}else{
	    if($row_reg_egresos['FLAG_CIERRECAJA']=='N')
		echo "No";
		}
		?></td>
        <td><?php echo $row_reg_egresos['OBS']; ?></td>
      </tr>
      <?php } while ($row_reg_egresos = mysql_fetch_assoc($reg_egresos)); ?>
      </tbody>
  </table>
  <table border="0" align="center">
    <tr>
      <td><?php if ($pageNum_reg_egresos > 0) { // Show if not first page ?>
          <a href="<?php printf("%s?pageNum_reg_egresos=%d%s", $currentPage, 0, $queryString_reg_egresos); ?>"><img src="First.gif" /></a>
      <?php } // Show if not first page ?></td>
      <td><?php if ($pageNum_reg_egresos > 0) { // Show if not first page ?>
          <a href="<?php printf("%s?pageNum_reg_egresos=%d%s", $currentPage, max(0, $pageNum_reg_egresos - 1), $queryString_reg_egresos); ?>"><img src="Previous.gif" /></a>
      <?php } // Show if not first page ?></td>
      <td align="center">Registros <?php echo ($startRow_reg_egresos + 1) ?> a <?php echo min($startRow_reg_egresos + $maxRows_reg_egresos, $totalRows_reg_egresos) ?> de <?php echo $totalRows_reg_egresos ?></td>
      <td><?php if ($pageNum_reg_egresos < $totalPages_reg_egresos) { // Show if not last page ?>
          <a href="<?php printf("%s?pageNum_reg_egresos=%d%s", $currentPage, min($totalPages_reg_egresos, $pageNum_reg_egresos + 1), $queryString_reg_egresos); ?>"><img src="Next.gif" /></a>
          <?php } // Show if not last page ?></td>
      <td><?php if ($pageNum_reg_egresos < $totalPages_reg_egresos) { // Show if not last page ?>
          <a href="<?php printf("%s?pageNum_reg_egresos=%d%s", $currentPage, $totalPages_reg_egresos, $queryString_reg_egresos); ?>"><img src="Last.gif" /></a>
          <?php } // Show if not last page ?></td>
    </tr>
  </table>
  <?php } // Show if recordset not empty ?>
<?php if ($totalRows_reg_egresos == 0) { // Show if recordset empty ?>
  <table class="table table-responsive">
    <tr>
      <td align="center"><em>No Existen Egresos Registrados en el Sistema</em></td>
    </tr>
  </table>
  <?php } // Show if recordset empty ?>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => '<h2><strong>Registro de Egresos</strong><em></em></h2>',
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		//configure ribbon (breadcrumbs) array("name"=>"url"), leave url empty if no url
		//$breadcrumbs["New Crumb"] => "http://url.com"
		//$breadcrumbs["Mantención de Exámenes"] = "../EXAMENES/mostrar_exV2.php";
		include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
    <div id="content">	
		<?php
            $widget->print_html();
        ?>
	</div>
    		<!-- modal Edit-->
<!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->
<script>

		// PAGE RELATED SCRIPTS
	$(document).ready(function(){
				$('#dataTables-example').DataTable({
                         'lengthMenu': [[20, 50, 100,1000], [20, 50, 100,1000]],
                         'language': {
                             	"sProcessing":   "Procesando...",
								"sZeroRecords":  "No se encontraron resultados",
								"sInfoPostFix":  "",
								"sUrl":          "",
								"oPaginate": {
									"sFirst":    "Primero",
									"sPrevious": "Anterior",
									"sNext":     "Siguiente",
									"sLast":     "Último"
								},
                             "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
                             "sInfoEmpty":    "0 Registros",
                             "sInfoFiltered": "(de _MAX_ Registros en total)",
							 "sLengthMenu":"Mostrar _MENU_ Registros",
							 "sSearch":"Buscar Egresos: "
                         },
                         'pageLength' : 20,
                         'order' : [ 0, "asc" ],
                         'columns': [
                             null,
                             null,
							 null,
                             null,  
							 null,
                             null,
							 null,
                             null,
                         ],
                         'destroy': true
           		});//DataTables
	});

</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>